import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;

public class Main {

	/**
	 * @param args
	 */

	static Capteur[] capteurs = new Capteur[3];

	// programme princpal
	public static void main(String[] args) {

		String delimiter = " ";
		String[] tmp = null;
		final int maxLengh = 5;

		try {
			// Open the file that is the first
			// command line parameter
			FileInputStream fstream = new FileInputStream("data.txt");
			FileOutputStream ostream = new FileOutputStream("result.txt");
			// Get the object of DataInputStream
			DataInputStream in = new DataInputStream(fstream);
			BufferedReader br = new BufferedReader(new InputStreamReader(in));

			DataOutputStream out = new DataOutputStream(ostream);
			BufferedWriter wr = new BufferedWriter(new OutputStreamWriter(out));
			String strLine;

			// Read File Line By Line
			while ((strLine = br.readLine()) != null) {
				boolean isError = false;
				capteurs = new Capteur[3];
				String result = "";
				tmp = strLine.split(delimiter);
				wr.write(strLine);
				if (tmp.length != maxLengh) {
					wr.write(" ERROR");
					isError = true;

					// break;
				} else
					// traitement des donnes de chaque colonne
					for (int j = 1; j < tmp.length - 1; j++)
						if (isValid(tmp[j])) {
							capteurs[j - 1] = makeCapteur(tmp[j]);
						} else {
							wr.write(" ERROR");
							isError = true;
							break;
						}

				if (!isError)
					result = voteur(capteurs);
				wr.write(result + "\n");

			}
			// Close the input stream
			in.close();

			wr.close();
		} catch (Exception e) {// Catch exception if any
			System.err.println("Error: " + e.getMessage());
		}

	}

	/**
	 * methode principale contenant la partie mtier de voteur
	 * */
	private static String voteur(Capteur[] capteurs) {

		int tolerance = 5;
		int nbCapteursCoherent = 2;
		int somme = 0;
		int avg = 0;
		int resValidity = 0; // true= 1 et false=0
		String res = "";
		ArrayList<Capteur> listCapteurs = new ArrayList<Capteur>();

		for (int i = 0; i < capteurs.length; i++) {
			if (capteurs[i].getValidity() == 1) {
				listCapteurs.add(capteurs[i]);
			}
		}

		// tous les capteurs sont valides
		if (listCapteurs.size() == capteurs.length) {
			resValidity = 1;
			for (int i = 0; i < capteurs.length; i++) {
				somme += capteurs[i].getValue();
			}
			avg = (somme / capteurs.length);

			// seuls 2 sont valides
		} else if (listCapteurs.size() == nbCapteursCoherent) {
			if (Math.abs(listCapteurs.get(0).getValue()
					- listCapteurs.get(1).getValue()) <= tolerance) {
				resValidity = 1;
				somme = listCapteurs.get(0).getValue()
						+ listCapteurs.get(1).getValue();
				avg = (somme / nbCapteursCoherent);
			}

			// 1 seul est valide !
		} else if (listCapteurs.size() == 1) {
			resValidity = (listCapteurs.get(0).getValue() >= 70 || listCapteurs
					.get(0).getValue() >= 950) ? 1 : 0;
			if (resValidity == 1)
				avg = listCapteurs.get(0).getValue();
			else
				avg = 0;

		} else if (listCapteurs.size() < 1) {
			resValidity = 0;
		}

		res = " " + resValidity + avg;
		return res;
	}

	/**
	 * analyse la chaine de caractre de l'utilisateur, pour bien distinguer la
	 * partie validit de la partie valeur
	 */
	public static Capteur makeCapteur(String nb) {

		int valid = Integer.parseInt(nb.substring(0, 1));
		int value = Integer.parseInt(nb.substring(1, nb.length()));
		return new Capteur(valid, value);
	}

	/**
	 * verifie que la chaine lue est un entier qui respect le format [0|1][0-9]+
	 */
	private static boolean isValid(String nb) {

		String validity = "";
		String value = "";

		if (nb.length() < 2 || nb.length() > 5)
			return false;

		try {

			validity = nb.substring(0, 1);
			value = nb.substring(1, nb.length());
			return validity.matches("0|1")
					&& (Integer.parseInt(value) >= 0 && Integer.parseInt(value) <= 1023);
		} catch (NumberFormatException e) {
			return false;
		}
	}
}
